<?php
include 'admin_sidebar.php'; 

session_start();
require 'db.php';

if(!isset($_GET['id'])){
    die("Invalid property.");
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("
    SELECT properties.*, users.fullname, users.email, users.phoneno
    FROM properties
    LEFT JOIN users ON properties.agent_id = users.id
    WHERE properties.id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$property = $result->fetch_assoc();

if(!$property){
    die("Property not found.");
}

$imgQuery = $conn->query("SELECT * FROM property_images WHERE property_id = $id");
?>

<!DOCTYPE html>
<html>
<head>
<title>Property Details</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f4f4f4; }
.navbar { background:#000; }
.navbar a { color:#fff !important; }
</style>
</head>

<body>

<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">Admin Dashboard</a>
    <a href="dashboard.php" class="btn btn-light btn-sm ms-auto">Back</a>
  </div>
</nav>

<div class="container">

  <div class="card p-4 shadow-sm">
    <h3><?= htmlspecialchars($property['title']); ?></h3>

    <img src="<?= $property['img']; ?>" class="img-fluid mb-3 rounded">

    <h5>Description:</h5>
    <p><?= nl2br(htmlspecialchars($property['description'])); ?></p>

    <p><strong>Price:</strong> ₦<?= number_format($property['price']); ?></p>
    <p><strong>Location:</strong> <?= htmlspecialchars($property['location']); ?></p>
    <p><strong>Category:</strong> <?= htmlspecialchars($property['category']); ?></p>
    <p><strong>Type:</strong> <?= htmlspecialchars($property['type']); ?></p>

    <hr>

    <h4>Agent Information</h4>
    <p><strong>Name:</strong> <?= htmlspecialchars($property['fullname']); ?></p>
    <p><strong>Email:</strong> <?= htmlspecialchars($property['email']); ?></p>
    <p><strong>Phone:</strong> <?= htmlspecialchars($property['phoneno']); ?></p>

    <hr>

    <h4>Other Images</h4>
    <div class="row">

        <?php while($img = $imgQuery->fetch_assoc()): ?>
        <div class="col-md-3 mb-3">
            <img src="<?= $img['image_path']; ?>" 
                 class="img-fluid rounded" 
                 style="height:150px; object-fit:cover;">
        </div>
        <?php endwhile; ?>

    </div>

  </div>

</div>

</body>
</html>
