<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Agent Login / Register - Tbil Properties</title>

<link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
<link href="assets/vendor/aos/aos.css" rel="stylesheet">
<link href="assets/css/main.css" rel="stylesheet">

<style>
body {
  background: #f4f6f9;
}
.auth-box {
  max-width: 450px;
  margin: 50px auto;
  background: #fff;
  padding: 30px;
  border-radius: 15px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}
.toggle-links span {
  cursor: pointer;
  font-weight: 600;
}
.form-section {
  display: none;
}
.form-section.active {
  display: block;
}
</style>
</head>

<body>

<div class="container">
  <div class="auth-box" data-aos="fade-up">

    <h3 class="text-center mb-4">Agent / Seller Access</h3>

    <!-- Alerts -->
    <?php
    session_start();
    if (isset($_SESSION['error'])) {
        echo "<div class='alert alert-danger'>".$_SESSION['error']."</div>";
        unset($_SESSION['error']);
    }
    if (isset($_SESSION['success'])) {
        echo "<div class='alert alert-success'>".$_SESSION['success']."</div>";
        unset($_SESSION['success']);
    }
    ?>

    <!-- Toggle -->
    <div class="text-center mb-3 toggle-links">
      <span id="showLogin">Login</span> | 
      <span id="showRegister">Sign Up</span>
    </div>

    <!-- Login Form -->
    <form action="auth-handler.php" method="POST" class="form-section" id="loginForm">
      <input type="hidden" name="action" value="login">

      <div class="mb-3">
        <label>Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>

      <button class="btn btn-primary w-100">Login</button>
    </form>

    <!-- Register Form -->
    <form action="auth-handler.php" method="POST" class="form-section" id="registerForm">
      <input type="hidden" name="action" value="register">

      <div class="mb-3">
        <label>Full Name</label>
        <input type="text" name="fullname" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Email Address</label>
        <input type="email" name="email" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Phone</label>
        <input type="text" name="phone" class="form-control">
      </div>

      <div class="mb-3">
        <label>Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>

      <button class="btn btn-success w-100">Create Account</button>
    </form>

  </div>
</div>

<script>
let loginForm = document.getElementById("loginForm");
let registerForm = document.getElementById("registerForm");

document.getElementById("showLogin").addEventListener("click", function(){
  loginForm.classList.add("active");
  registerForm.classList.remove("active");
});

document.getElementById("showRegister").addEventListener("click", function(){
  registerForm.classList.add("active");
  loginForm.classList.remove("active");
});

// Default view (login)
loginForm.classList.add("active");
</script>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/aos/aos.js"></script>
<script>
AOS.init();
</script>

</body>
</html>
