<?php
include 'navbar.php';
?>

  <main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section">

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="hero-wrapper">
          <div class="row g-4">

            <div class="col-lg-7">
              <div class="hero-content" data-aos="zoom-in" data-aos-delay="200">
                <div class="content-header">
                  <span class="hero-label">
                     <i class="bi bi-house-heart"></i>
                Welcome to Tbil Properties
              </span>
              <h1> Explore Nigeria’s Best Properties Today!</h1>
              <p>Explore premium properties across Nigeria with Tbil Properties. Whether you're buying, renting, or investing — our experienced agents are ready to guide you every step of the way.</p>
            </div>

                <div class="search-container" data-aos="fade-up" data-aos-delay="300">
                  <div class="search-header">
                    <h3>Start Your Property Search</h3>
                    <p>Discover our verified properties</p>
                  </div>

                 <form action="search_results.php" method="GET" class="property-search-form">
  <div class="search-grid">
    <div class="search-field">
      <label for="search-location" class="field-label">Location</label>
      <input type="text" id="search-location" name="location" placeholder="Enter city or neighborhood">
      <i class="bi bi-geo-alt field-icon"></i>
    </div>

    <div class="search-field">
      <label for="search-type" class="field-label">Property Type</label>
      <select id="search-type" name="type">
        <option value="">All Types</option>
        <option value="rent">For Rent</option>
        <option value="sale">For Sale</option>
        <option value="shortlet">Shorlet</option>
      </select>
      <i class="bi bi-building field-icon"></i>
    </div>

    <div class="search-field">
      <label for="search-budget" class="field-label">Budget Range</label>
      <select id="search-budget" name="price_range">
        <option value="">Any Price</option>
        <option value="0-30000000">Under N50,000,000</option>
        <option value="30000000-60000000">N50,000,000 - N150,000,000</option>
        <option value="60000000-90000000">N150,000,000 - N300,000,000</option>
        <option value="90000000-150000000">N300,000,000 Upwards</option>
      </select>
      <i class="bi bi-currency-dollar field-icon"></i>
    </div>

    <div class="search-field">
      <label for="search-rooms" class="field-label">Bedrooms</label>
      <select id="search-rooms" name="bedrooms">
        <option value="">Any</option>
        <option value="1">1 Room</option>
        <option value="2">2 Rooms</option>
        <option value="3">3 Rooms</option>
        <option value="4">4 Rooms</option>
        <option value="5+">5+ Rooms</option>
      </select>
      <i class="bi bi-door-open field-icon"></i>
    </div>
  </div>

  <button type="submit" class="search-btn">
    <i class="bi bi-search"></i>
    <span>Find Properties</span>
  </button>
</form>

                </div>

                <div class="achievement-grid" data-aos="fade-up" data-aos-delay="400">
                  <div class="achievement-item">
                    <div class="achievement-number">
                      <span data-purecounter-start="0" data-purecounter-end="1250" data-purecounter-duration="1" class="purecounter"></span>+
                    </div>
                    <span class="achievement-text">Active Listings</span>
                  </div>
                  <div class="achievement-item">
                    <div class="achievement-number">
                      <span data-purecounter-start="0" data-purecounter-end="89" data-purecounter-duration="1" class="purecounter"></span>+
                    </div>
                    <span class="achievement-text">Expert Agents</span>
                  </div>
                  <div class="achievement-item">
                    <div class="achievement-number">
                      <span data-purecounter-start="0" data-purecounter-end="96" data-purecounter-duration="1" class="purecounter"></span>%
                    </div>
                    <span class="achievement-text">Success Rate</span>
                  </div>
                </div>
              </div>
            </div><!-- End Hero Content -->

            <div class="col-lg-5">
              <div class="hero-visual" data-aos="fade-left" data-aos-delay="400">
                <div class="visual-container">
                  <div class="featured-property">
                    <img src="assets/img/real-estate/property-exterior-8.webp" alt="Featured Property" class="img-fluid">
                    
                  </div>

                  <div class="overlay-images">
                    <div class="overlay-img overlay-1">
                      <img src="assets/img/real-estate/property-interior-4.webp" alt="Interior View" class="img-fluid">
                    </div>
                    <div class="overlay-img overlay-2">
                      <img src="assets/img/real-estate/property-exterior-2.webp" alt="Exterior View" class="img-fluid">
                    </div>
                  </div>

                  <div class="agent-card">
                    <div class="agent-profile">
                      <img src="assets/img/logo.png" alt="Agent Profile" class="agent-photo">
                      <div class="agent-info">
                        <h4>NO 1</h4>
                        <p>Most trusted property finder in Nigeria</p>
                        <div class="agent-rating">
                          <div class="stars">
                            <i class="bi bi-star-fill"></i>
                            <i class="bi bi-star-fill"></i>
                            <i class="bi bi-star-fill"></i>
                            <i class="bi bi-star-fill"></i>
                            <i class="bi bi-star-fill"></i>
                          </div>
                          <span class="rating-text">5.0 (94 reviews)</span>
                        </div>
                      </div>
                    </div>
                    <button class="contact-agent-btn">
                      <i class="bi bi-chat-dots"></i>
                    </button>
                  </div>
                </div>
              </div>
            </div><!-- End Hero Visual -->

          </div>
        </div>

      </div>

    </section><!-- /Hero Section -->

    <!-- Home About Section -->
    <section id="home-about" class="home-about section">

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row gy-5">

          <div class="col-lg-5" data-aos="zoom-in" data-aos-delay="200">
            <div class="image-gallery">
              <div class="primary-image">
                <img src="assets/img/real-estate/property-exterior-1.webp" alt="Modern Property" class="img-fluid">
                <div class="experience-badge">
                  <div class="badge-content">
                    <div class="number"><span data-purecounter-start="0" data-purecounter-end="15" data-purecounter-duration="1" class="purecounter"></span>+</div>
                    <div class="text">Years<br>Experience</div>
                  </div>
                </div>
              </div>
              <div class="secondary-image">
                <img src="assets/img/real-estate/property-interior-4.webp" alt="Luxury Interior" class="img-fluid">
              </div>
            </div>
          </div>

         <div class="col-lg-7" data-aos="fade-left" data-aos-delay="300">
  <div class="content">
    <div class="section-header">
        <span class="section-label">Who We Are</span>
        <h2>Turning Properties into Possibilities Since 2008</h2>
      </div>

      <p>At Tbil Properties, we’re more than just agents — we’re dream builders. Since 2008, we’ve helped individuals, families, and investors secure quality properties and turn real estate goals into lasting value.</p>

      <div class="achievements-list">
        <div class="achievement-item">
          <div class="achievement-icon">
            <i class="bi bi-house-door"></i>
          </div>
          <div class="achievement-content">
            <h4><span data-purecounter-start="0" data-purecounter-end="320" data-purecounter-duration="2" class="purecounter"></span>+ Homes Delivered</h4>
            <p>From first-time buyers to seasoned investors</p>
          </div>
        </div>
        <div class="achievement-item">
          <div class="achievement-icon">
            <i class="bi bi-people"></i>
          </div>
          <div class="achievement-content">
            <h4><span data-purecounter-start="0" data-purecounter-end="98" data-purecounter-duration="1" class="purecounter"></span>% Customer Satisfaction</h4>
          <p>Our clients trust and recommend us</p>
        </div>
      </div>
    </div>

    <div class="action-section">
      <a href="about.html" class="btn-cta">
        <span>Learn More About Tbil Properties</span>
        <i class="bi bi-arrow-right"></i>
      </a>
      <div class="contact-info">
        <div class="contact-icon">
          <i class="bi bi-telephone"></i>
        </div>
        <div class="contact-details">
          <span>Speak With An Expert</span>
          <strong>+234 707 829 8571</strong>
        </div>
      </div>
    </div>
  </div>
</div>

        </div>

      </div>

    </section><!-- /Home About Section -->
   <section> 
<?php
require "db.php";

// Fetch latest 6 available properties
$featured = $conn->query("SELECT * FROM properties WHERE aos = 'available' ORDER BY created_at DESC LIMIT 6");

?>


<div class="container mt-5">

    <h3 class="mb-4 text-center">Latest Properties</h3>

    <div class="row">
        <?php if ($featured->num_rows > 0): ?>
            <?php while($row = $featured->fetch_assoc()): ?>

            <div class="col-md-4 mb-4">
                <div class="card shadow-sm">

                    <!-- Property Image -->
                    <img src="<?= $row['img']; ?>" class="card-img-top" style="height:230px; object-fit:cover;">

                    <div class="card-body">

                        <h5 class="card-title"><?= htmlspecialchars($row['title']); ?></h5>

                        <!-- TYPE BADGE -->
                        <span class="badge bg-primary text-uppercase"><?= $row['type']; ?></span>

                        <!-- STATUS BADGE -->
                        <?php if($row['status'] == 'available'): ?>
                            <span class="badge bg-success">Available</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Sold</span>
                        <?php endif; ?>

                        <p class="fw-bold mt-2">₦<?= number_format($row['price']); ?></p>
                        <p class="text-muted mb-1"><?= $row['location']; ?></p>

                        <p><?= substr($row['description'], 0, 60); ?>...</p>

                        <!-- View More -->
                         
                      <a href="view_single_property.php?id=<?= $row['id']; ?>" 
   class="fw-bold" 
   style="background-color: #000; color: white; font-size: 1.1rem; padding: 0.6rem 1.2rem; border-radius: 0.6rem; text-decoration: none; display: inline-block; text-align: center;">
   View
</a>


                    </div>
                </div>
            </div>

            <?php endwhile; ?>
        <?php else: ?>
            <p class="text-center">No properties available at the moment.</p>
        <?php endif; ?>
    </div>

</div>

</section>


  <!-- Featured Services Section -->

<section id="featured-services" class="featured-services section py-5">

  <!-- Section Title -->

  <div class="container section-title" data-aos="fade-up">
    <h2>Our Core Services</h2>
    <p>At <strong>Tbil Properties</strong>, we connect buyers and sellers with verified properties, ensuring seamless transactions for buying, selling, renting, or investing.</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">

```
<div class="row g-4">

  <div class="col-lg-6" data-aos="fade-right" data-aos-delay="200">
    <div class="service-card p-4 rounded" style="background-color:#f8f9fa;">
      <div class="service-icon">
        <i class="bi bi-search"></i>
      </div>
      <div class="service-info">
        <h3><a href="user_view_all_properties.php">Property Search</a></h3>
        <p>Discover the perfect property with our verified listings and smart search tools, making your property hunt simple and efficient.</p>
        <ul class="service-highlights">
          <li><i class="bi bi-check-circle-fill"></i> Verified Listings</li>
          <li><i class="bi bi-check-circle-fill"></i> Advanced Search Filters</li>
          <li><i class="bi bi-check-circle-fill"></i> Virtual Property Tours</li>
        </ul>
        <a href="user_view_all_properties.php" class="service-link">
          <span>Explore Now</span>
          <i class="bi bi-arrow-up-right"></i>
        </a>
      </div>
      <div class="service-visual">
        <img src="assets/img/real-estate/property-interior-2.webp" class="img-fluid" alt="Property Search" loading="lazy">
      </div>
    </div>
  </div>

  <div class="col-lg-6" data-aos="fade-left" data-aos-delay="300">
    <div class="service-card p-4 rounded" style="background-color:#fff3e0;">
      <div class="service-icon">
        <i class="bi bi-calculator"></i>
      </div>
      <div class="service-info">
        <h3><a href="service-details.html">Property Valuation</a></h3>
        <p>Know the true value of your property with accurate assessments, enabling smart buying, selling, or investment decisions.</p>
        <ul class="service-highlights">
          <li><i class="bi bi-check-circle-fill"></i> Market Analysis</li>
          <li><i class="bi bi-check-circle-fill"></i> Detailed Valuation Reports</li>
          <li><i class="bi bi-check-circle-fill"></i> Expert Investment Guidance</li>
        </ul>
        <a href="service-details.html" class="service-link">
          <span>Get Valuation</span>
          <i class="bi bi-arrow-up-right"></i>
        </a>
      </div>
      <div class="service-visual">
        <img src="assets/img/real-estate/property-exterior-1.webp" class="img-fluid" alt="Property Valuation" loading="lazy">
      </div>
    </div>
  </div>

</div>

<div class="row g-4 mt-4">

  <div class="col-lg-6" data-aos="fade-right" data-aos-delay="400">
    <div class="service-card p-4 rounded" style="background-color:#e0f7fa;">
      <div class="service-icon">
        <i class="bi bi-key"></i>
      </div>
      <div class="service-info">
        <h3><a href="service-details.html">Rental Services</a></h3>
        <p>We connect verified property owners with qualified tenants and manage the rental process for a smooth experience.</p>
        <ul class="service-highlights">
          <li><i class="bi bi-check-circle-fill"></i> Verified Tenants</li>
          <li><i class="bi bi-check-circle-fill"></i> Lease Management</li>
          <li><i class="bi bi-check-circle-fill"></i> Maintenance Support</li>
        </ul>
        <a href="service-details.html" class="service-link">
          <span>Start Renting</span>
          <i class="bi bi-arrow-up-right"></i>
        </a>
      </div>
      <div class="service-visual">
        <img src="assets/img/real-estate/property-interior-8.webp" class="img-fluid" alt="Property Rental" loading="lazy">
      </div>
    </div>
  </div>

  <div class="col-lg-6" data-aos="fade-left" data-aos-delay="500">
    <div class="service-card p-4 rounded" style="background-color:#e8f5e9;">
      <div class="service-icon">
        <i class="bi bi-shield-check"></i>
      </div>
      <div class="service-info">
        <h3><a href="service-details.html">Investment Opportunities</a></h3>
        <p>Maximize your returns with secure, verified properties and expert guidance for smart real estate investments.</p>
        <ul class="service-highlights">
          <li><i class="bi bi-check-circle-fill"></i> Tailored Investment Plans</li>
          <li><i class="bi bi-check-circle-fill"></i> Risk & ROI Analysis</li>
          <li><i class="bi bi-check-circle-fill"></i> Market Insights</li>
        </ul>
        <a href="service-details.html" class="service-link">
          <span>Learn More</span>
          <i class="bi bi-arrow-up-right"></i>
        </a>
      </div>
      <div class="service-visual">
        <img src="assets/img/real-estate/property-exterior-4.webp" class="img-fluid" alt="Investment Opportunities" loading="lazy">
      </div>
    </div>
  </div>

</div>

<div class="text-center mt-4" data-aos="zoom-in" data-aos-delay="600">
  <a href="services.html" class="btn-view-all">
    <span>View All Services</span>
    <i class="bi bi-arrow-right"></i>
  </a>
</div>
```

  </div>

</section><!-- /Featured Services Section -->

<!-- Testimonials Section -->

<section id="testimonials" class="testimonials section light-background">

  <!-- Section Title -->

  <div class="container section-title" data-aos="fade-up">
    <h2>Client Testimonials</h2>
    <p>Hear from our clients about how Tbil Properties connects buyers with sellers, agents with renters, and ensures verified, secure transactions.</p>
  </div>

  <div class="container">

```
<div class="testimonial-grid">

  <div class="testimonial-item" data-aos="zoom-in" data-aos-delay="100">
    <div class="testimonial-card">
      <div class="testimonial-header">
        <div class="testimonial-image">
          <img src="assets/img/testimonial-1.jpg" class="img-fluid" alt="Testimonial 1">
        </div>
        <div class="testimonial-meta">
          <h3>Grace Adeyemi</h3>
          <h4>Interior Designer</h4>
          <div class="company-logo">
            <i class="bi bi-building"></i>
            <i class="bi bi-chat-quote-fill quote-icon"></i>
          </div>
        </div>
      </div>
      <div class="testimonial-body">
        
        <p>Tbil Properties connected me with the perfect verified property and guided me through the process professionally. I felt confident knowing the property and agents were thoroughly verified.</p>
      </div>
    </div>
  </div>

  <div class="testimonial-item featured" data-aos="zoom-in" data-aos-delay="200">
    <div class="testimonial-card">
      <div class="testimonial-header">
        <div class="testimonial-image">
          <img src="assets/img/image1.jpeg" class="img-fluid" alt="Testimonial 2">
        </div>
        <div class="testimonial-meta">
          <h3>Bola Johnson</h3>
          <h4>CEO, Bamidele Holdings</h4>
          <div class="company-logo">
            <i class="bi bi-buildings"></i>
            <i class="bi bi-chat-quote-fill quote-icon"></i>
          </div>
        </div>
      </div>
      <div class="testimonial-body">
        
        <p>Thanks to Tbil Properties, we connected with a verified seller quickly and completed a premium property purchase without stress. Their attention to verification gave us peace of mind.</p>
      </div>
    </div>
  </div>

  <div class="testimonial-item featured" data-aos="zoom-in" data-aos-delay="300">
    <div class="testimonial-card">
      <div class="testimonial-header">
        <div class="testimonial-image">
          <img src="assets/img/image2.jpeg" class="img-fluid" alt="Testimonial 3">
        </div>
        <div class="testimonial-meta">
          <h3>Oluchi Nwankwo</h3>
          <h4>Business Consultant</h4>
          <div class="company-logo">
            <i class="bi bi-building-check"></i>
            <i class="bi bi-chat-quote-fill quote-icon"></i>
          </div>
        </div>
      </div>
      <div class="testimonial-body">
        
        <p>The team connected me with verified agents and ensured the property was legitimate. I highly recommend Tbil Properties for smooth and trustworthy transactions.</p>
      </div>
    </div>
  </div>

  <div class="testimonial-item" data-aos="zoom-in" data-aos-delay="400">
    <div class="testimonial-card">
      <div class="testimonial-header">
        <div class="testimonial-image">
          <img src="assets/img/img.jpeg" class="img-fluid" alt="Testimonial 4">
        </div>
        <div class="testimonial-meta">
          <h3>Femi Olatunji</h3>
          <h4>IT Specialist</h4>
          <div class="company-logo">
            <i class="bi bi-building-gear"></i>
             <i class="bi bi-chat-quote-fill quote-icon"></i>
          </div>
        </div>
      </div>
      <div class="testimonial-body">
       
        <p>They connected me with a qualified tenant and ensured both the property and agent were verified. Tbil Properties makes renting simple and secure.</p>
      </div>
    </div>
  </div>

</div>
```

  </div>

</section><!-- /Testimonials Section -->

<!-- Why Us Section -->

<section id="why-us" class="why-us section py-5">

  <!-- Section Title -->

  <div class="container section-title" data-aos="fade-up">
    <h2>Why Choose Tbil Properties</h2>
    <p>Discover why Tbil Properties is the trusted partner for buying, selling, renting, and investing in verified real estate.</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">

```
<div class="row gy-4">

  <div class="col-lg-6" data-aos="fade-right" data-aos-delay="200">
    <div class="content">
      <h3>Your Trusted Real Estate Partner</h3>
      <p>At Tbil Properties, we connect verified buyers with sellers, and qualified renters with trusted agents. Every property and agent is thoroughly verified to ensure secure, seamless, and stress-free transactions.</p>

      <div class="features-list">
        <div class="feature-item d-flex align-items-center mb-3">
          <div class="icon-wrapper me-3">
            <i class="bi bi-check-circle-fill"></i>
          </div>
          <div>
            <h5>In-Depth Local Knowledge</h5>
            <p>We understand neighborhoods, pricing trends, and investment opportunities to help you make informed decisions.</p>
          </div>
        </div>

        <div class="feature-item d-flex align-items-center mb-3">
          <div class="icon-wrapper me-3">
            <i class="bi bi-shield-check"></i>
          </div>
          <div>
            <h5>Verified Listings & Agents</h5>
            <p>All properties and agents are carefully screened for authenticity, ensuring every connection is trustworthy.</p>
          </div>
        </div>

        <div class="feature-item d-flex align-items-center mb-3">
          <div class="icon-wrapper me-3">
            <i class="bi bi-headset"></i>
          </div>
          <div>
            <h5>Responsive Support</h5>
            <p>Our team is always ready to answer questions and assist you at every stage of your real estate journey.</p>
          </div>
        </div>

        <div class="feature-item d-flex align-items-center mb-3">
          <div class="icon-wrapper me-3">
            <i class="bi bi-graph-up-arrow"></i>
          </div>
          <div>
            <h5>Proven Track Record</h5>
            <p>We have successfully connected thousands of clients with verified properties, sellers, and renters over the years.</p>
          </div>
        </div>
      </div>

      <div class="cta-buttons mt-4">
        <a href="#" class="btn btn-primary me-3">Learn More About Us</a>
        <a href="#" class="btn btn-outline-primary">Talk to an Agent</a>
      </div>
    </div>
  </div>

  <div class="col-lg-6" data-aos="fade-left" data-aos-delay="300">
    <div class="stats-section">
      <div class="row gy-4">

        <div class="col-md-6">
          <div class="stat-card text-center p-4 rounded" style="background-color:#f8f9fa;">
            <div class="stat-icon mb-3">
              <i class="bi bi-house-door"></i>
            </div>
            <div class="stat-number">
              <span data-purecounter-start="0" data-purecounter-end="2500" data-purecounter-duration="2" class="purecounter"></span>+
            </div>
            <div class="stat-label">Properties Sold</div>
            <p>Over 2,500 clients successfully connected with verified properties and sellers.</p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="stat-card text-center p-4 rounded" style="background-color:#e0f7fa;">
            <div class="stat-icon mb-3">
              <i class="bi bi-people"></i>
            </div>
            <div class="stat-number">
              <span data-purecounter-start="0" data-purecounter-end="98" data-purecounter-duration="2" class="purecounter"></span>%
            </div>
            <div class="stat-label">Happy Clients</div>
            <p>Our verified connections and dedicated service deliver 98% client satisfaction.</p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="stat-card text-center p-4 rounded" style="background-color:#fff3e0;">
            <div class="stat-icon mb-3">
              <i class="bi bi-clock-history"></i>
            </div>
            <div class="stat-number">
              <span data-purecounter-start="0" data-purecounter-end="20" data-purecounter-duration="2" class="purecounter"></span>+
            </div>
            <div class="stat-label">Years in Business</div>
            <p>20+ years of connecting verified buyers, sellers, and renters with trusted properties and agents.</p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="stat-card text-center p-4 rounded" style="background-color:#e8f5e9;">
            <div class="stat-icon mb-3">
              <i class="bi bi-award"></i>
            </div>
            <div class="stat-number">
              <span data-purecounter-start="0" data-purecounter-end="45" data-purecounter-duration="2" class="purecounter"></span>+
            </div>
            <div class="stat-label">Industry Recognitions</div>
            <p>Over 45 awards recognizing our integrity and excellence in real estate services.</p>
          </div>
        </div>

      </div>

      <div class="testimonial-preview mt-5">
        <div class="testimonial-card">
          <div class="quote-icon mb-2">
            <i class="bi bi-quote"></i>
          </div>
          <p>"Tbil Properties made buying our new apartment completely stress-free. Their professionalism and verified connections were unmatched."</p>
          <div class="testimonial-author d-flex align-items-center mt-3">
            <img src="assets/img/image1.jpeg" alt="Client" class="author-image me-3">
            <div>
              <h6>Bola Johnson</h6>
              <span>First-time Buyer</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
```

  </div>

</section><!-- /Why Us Section -->

<!-- Call To Action Section -->

<section class="call-to-action-1 call-to-action section" id="call-to-action">
  <div class="cta-bg" style="background-image: url('assets/img/real-estate/showcase-3.webp');"></div>
  <div class="container" data-aos="fade-up" data-aos-delay="100">

```
<div class="row justify-content-center">
  <div class="col-xl-6 col-lg-8">

    <div class="cta-content text-center">
      <h2>Looking for Your Ideal Home or Investment?</h2>
      <p>Let Tbil Properties guide you to the perfect verified property. Whether buying, renting, or investing, our expert team ensures safe, seamless, and rewarding transactions.</p>

      <div class="cta-buttons">
        <a href="#" class="btn btn-primary">Talk to Our Experts</a>
        <a href="#" class="btn btn-outline">Book a Free Consultation</a>
      </div>

      <div class="cta-features mt-3">
        <div class="feature-item" data-aos="fade-up" data-aos-delay="200">
          <i class="bi bi-telephone-fill"></i>
          <span>Free Property Advice</span>
        </div>
        <div class="feature-item" data-aos="fade-up" data-aos-delay="250">
          <i class="bi bi-clock-fill"></i>
          <span>Anytime, Anywhere</span>
        </div>
        <div class="feature-item" data-aos="fade-up" data-aos-delay="300">
          <i class="bi bi-shield-check-fill"></i>
          <span>Trusted & Verified</span>
        </div>
      </div>

    </div><!-- End CTA Content -->

  </div>
</div>
```

  </div>
</section><!-- /Call To Action Section -->

  </main>
<?php

include 'footer.php';

?>