<?php


session_start();

// Database connection
include'db.php';

$errors = [];
$email = '';
$password = '';

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';

    if (empty($email)) $errors[] = 'Email is required';
    if (empty($password)) $errors[] = 'Password is required';

    if (empty($errors)) {
        $query = $conn->prepare("SELECT id, fullname, password FROM users WHERE email = ?");
        $query->bind_param("s", $email);
        $query->execute();
        $query->store_result();

        if ($query->num_rows > 0) {
            $query->bind_result($id, $fullname, $db_password);
            $query->fetch();

            if ($password === $db_password) {
                $_SESSION['user_id'] = $id;
                $_SESSION['username'] = $email;
                 $_SESSION['fullname'] = $fullname;
                header("Location: dashboard.php");
                exit();
            } else {
                $errors[] = "Password does not match our records";
            }
        } else {
            $errors[] = "No user found with this email";
        }
        $query->close();
    }
}

$conn->close();
?>
<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Tbils Property</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">


<div class="container d-flex justify-content-center align-items-center" style="min-height: 80vh;">
    <div class="card shadow-lg p-4" style="width: 100%; max-width: 400px;">
<div class="text-center mb-4">
    <img src="assets/img/logo.png" width="70" height="70" class="d-block mx-auto mb-2" alt="Logo"/>
    
</div>

        <h3 class="text-center mb-4 fw-bold">Login</h3>

```
    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errors as $error) echo "<li>$error</li>"; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="" method="POST">
        <div class="mb-3">
            <label>Email</label>
            <input type="email" class="form-control" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
        </div>

        <div class="mb-3">
            <label>Password</label>
            <input type="password" class="form-control" name="password" required>
        </div>

        <button class="btn btn-primary w-100 py-2"style="background-color:#000">Login</button>
    </form>

    <p class="text-center mt-3">Don't have an account? <a href="register.php">Register</a></p>
</div>
```

</div>
