<?php
require 'db.php';

// Get search parameters from form
$location = $_GET['location'] ?? '';
$type = $_GET['type'] ?? '';
$price_range = $_GET['price_range'] ?? '';

// Save search into search_logs table
$log_stmt = $conn->prepare("INSERT INTO search_logs (location, type, price_range) VALUES (?, ?, ?)");
$log_stmt->bind_param("sss", $location, $type, $price_range);
$log_stmt->execute();
$log_stmt->close();

// Build dynamic SQL query
$sql = "SELECT * FROM properties WHERE 1=1";
$params = [];
$types = "";

// Location filter
if(!empty($location)){
    $sql .= " AND location LIKE ?";
    $params[] = "%$location%";
    $types .= "s";
}

// Property type filter
if(!empty($type)){
    $sql .= " AND type = ?";
    $params[] = $type;
    $types .= "s";
}

// Price range filter
if(!empty($price_range)){
    $range = explode("-", $price_range);
    if(count($range) === 2){
        $sql .= " AND price BETWEEN ? AND ?";
        $params[] = $range[0];
        $params[] = $range[1];
        $types .= "ii";
    }
}

// Prepare statement
$stmt = $conn->prepare($sql);
if(!empty($params)){
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>

<html lang="en">
<head>
<meta charset="UTF-8">
<title>Search Results | Tbil Properties</title>
<link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
<link href="assets/css/main.css" rel="stylesheet">
<style>
/* Ensure all cards have the same height */
.card {
    height: 100%;
    display: flex;
    flex-direction: column;
}
/* Make images uniform size */
.card-img-top {
    height: 200px;
    object-fit: cover;
}
/* Ensure card body takes remaining space */
.card-body {
    flex-grow: 1;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}
</style>
</head>
<body>

<div class="container mt-5">
    <h2 class="mb-4">Search Results</h2>

<?php if($result->num_rows > 0): ?>

```
<div class="row g-4">
<?php while($property = $result->fetch_assoc()): ?>
    <div class="col-md-4">
        <div class="card h-100">
            <img src="<?= htmlspecialchars($property['img']); ?>" class="card-img-top" alt="Property Image">
            <div class="card-body d-flex flex-column">
                <div>
                    <h5 class="card-title"><?= htmlspecialchars($property['title']); ?></h5>
                    <p class="card-text">
                        <i class="bi bi-geo-alt"></i> <?= htmlspecialchars($property['location']); ?><br>
                        ₦<?= number_format($property['price']); ?>
                    </p>
                </div>
                <a href="view_single_property.php?id=<?= $property['id']; ?>" class="btn btn-primary mt-auto">View Property</a>
            </div>
        </div>
    </div>
<?php endwhile; ?>
</div>
```

<?php else: ?>

```
<p>No properties found for your search criteria.</p>
```

<?php endif; ?>

</div>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

</body>
</html>
