<?php
include 'admin_sidebar.php'; 

require 'db.php'; // DB connection

// Handle delete action
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM subscribers WHERE id = $id");
    header("Location: admin_subscribers.php");
    exit;
}

// Search functionality
$search = "";
if (isset($_GET['search'])) {
    $search = mysqli_real_escape_string($conn, $_GET['search']);
    $query = $conn->query("SELECT * FROM subscribers 
                           WHERE email LIKE '%$search%' 
                           OR phone LIKE '%$search%'
                           ORDER BY id DESC");
} else {
    $query = $conn->query("SELECT * FROM subscribers ORDER BY id DESC");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Subscribers List</title>

<!-- Bootstrap CDN -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body class="bg-light">

<div class="container mt-5">
    <h2 class="fw-bold mb-4">Subscribers List</h2>

    <!-- Search Bar -->
    <form class="row mb-4" method="GET">
        <div class="col-md-4">
            <input type="text" name="search" value="<?php echo $search; ?>" 
                   class="form-control" placeholder="Search by email or phone">
        </div>
        <div class="col-md-2">
            <button class="btn btn-dark w-100">Search</button>
        </div>
    </form>

    <!-- Subscribers Table -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover bg-white">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Date Subscribed</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>

                <?php if ($query->num_rows > 0): ?>
                    <?php while ($row = $query->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo $row['email']; ?></td>
                            <td><?php echo $row['phone']; ?></td>
                            <td><?php echo $row['created_at']; ?></td>
                            <td>
                                <a href="admin_subscribers.php?delete=<?php echo $row['id']; ?>" 
                                   class="btn btn-danger btn-sm"
                                   onclick="return confirm('Are you sure you want to delete this subscriber?');">
                                    Delete
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center py-3">No subscribers found</td>
                    </tr>
                <?php endif; ?>

            </tbody>
        </table>
    </div>

</div>

</body>
</html>
